#include <wx/frame.h>
#include <wx/progdlg.h>

#include "Face.h"
#include "View.h"
#include "SDLSound.h"
#include "Timer.h"
#include "Frame.h"
#include "DicTraverser.h"

#include <XFace/FapFile.h>
#include <XEngine/RendererGL.h>
#include <XFace/FaceBase.h>

#ifdef WIN32
	#include "ItalianFlite.h"
#endif
 
namespace XFaceApp
{
	using namespace XFace;
	using namespace XEngine;

	//Constructor for Face class.
	Face::Face(View* view) : _view(view)
	{
	}

	//Initializes the Face class.
	bool Face::init()
	{
		//if the ApplicationBase initialized
		if(ApplicationBase::init())
		{
			DicTraverser traverser;
			wxDir dir(_T(".\\lang\\"));
			dir.Traverse(traverser);
			wxArrayString dics = traverser.getFileNames();

			for (int x = 0; unsigned(x) < dics.GetCount(); ++x)
			{
				m_pFace->addPhonemeDictionary((const char*)dics[x].c_str());
			}
			return true;
		}
		return false;
	}

	//Loads the xml file's values
	bool Face::createScriptProcessors()
	{
		return m_scriptProcLoader.load("scriptProcs.xml");
	}

	//Gets the Script Processor object
	boost::shared_ptr<IScriptProcessor> Face::getScriptProcessor(const std::string& name) const
	{
		return m_scriptProcLoader.getScriptProcessor(name);
	}

	//Creates the sound object
	boost::shared_ptr<ISound> Face::createSound() const
	{
		boost::shared_ptr<ISound> ret(new SDLSound);
		return ret;
	}

	//Creates the timer object
	boost::shared_ptr<XEngine::ITimer> Face::createTimer() const
	{
		boost::shared_ptr<XEngine::ITimer> ret(new Timer);
		return ret;
	}

	//Creates the Face object
	boost::shared_ptr<XFace::FaceBase> Face::createFace() const
	{
		boost::shared_ptr<XFace::FaceBase> ret(new XFace::FaceBase);
		return ret;
	}

	//Creates the renderer object
	boost::shared_ptr<XEngine::IRenderer> Face::createRenderer() const
	{
		boost::shared_ptr<XEngine::IRenderer> ret(new XEngine::RendererGL);
		return ret;
	}

	//Creates the FAP stream object
	boost::shared_ptr<XFace::IFapStream> Face::createFapStream() const
	{
		boost::shared_ptr<XFace::IFapStream> ret(new XFace::FAPFile);
		return ret;
	}

	bool Face::yield()
	{
		return wxTheApp->Yield(TRUE);
	}

	//Called when rendering begins
	void Face::renderBegin() const
	{
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
		glMatrixMode( GL_MODELVIEW );
		glPushMatrix();
	}

	//Called when rendering ends
	void Face::renderEnd() const
	{
		glPopMatrix();
		_view->SwapBuffers();
	}

	//Called when a frame needs to be rendered
	void Face::onRenderFrame() const
	{
		ApplicationBase::onRenderFrame();
	}

	//Called when a new task is created
	void Face::newTask(const Task& task)
	{
		ApplicationBase::newTask(task);
	}

	//Called when a task needs to be processed
	bool Face::processTask()
	{
		if (m_taskQueue.size() == 0)
		{
			return false;
		}
		
		return ApplicationBase::processTask();
	}
}
